/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators.RayMarching.Geometries;

import BryceImages.ColorCalculators.RayMarching.Geometries.geom_simpleCurve;
import BryceImages.ColorCalculators.RayMarching.Geometry;
import BryceImages.ColorCalculators.RayMarching.Vector;

public class geom_simpleLathe
extends Geometry {
    Vector z0;
    Vector z;
    Vector r;
    double radius1;
    double radius2;
    double thickness;
    double angle1;
    double angle2;

    public geom_simpleLathe(Vector z0, double r1, double r2, double thickness, Vector normal, double angle1, double angle2) {
        this.z0 = z0;
        this.radius1 = r1;
        this.radius2 = r2;
        this.thickness = thickness;
        this.createCoordinateSystem(normal);
        this.angle1 = angle1;
        this.angle2 = angle2;
    }

    @Override
    public double DE(Vector zz) {
        Vector diff = zz.sub(this.z0);
        double uComp = this.getComponent(diff, this.u);
        double vComp = this.getComponent(diff, this.v);
        double angle = geom_simpleLathe.lineAngle2(uComp, vComp, 0.0, 0.0);
        angle = geom_simpleLathe.degToRad(angle);
        Vector p1 = this.nearestSphere1(this.z0, this.radius1, angle);
        Vector n = this.nearestSphere1(this.z0, this.radius1, angle - 1.0E-8).sub(p1).norm();
        Vector uTemp = this.u.mult(uComp).add(this.v.mult(vComp)).norm();
        geom_simpleCurve g = new geom_simpleCurve(p1, this.radius2, this.thickness, n, uTemp, this.angle1, this.angle2);
        g.v = g.u.cross(n);
        return ((Geometry)g).DE(zz);
    }

    public Vector nearestSphere1(Vector z, double r, double angle) {
        return z.add(this.u.mult(r * geom_simpleLathe.cos(angle))).add(this.v.mult(r * geom_simpleLathe.sin(angle)));
    }
}

